.Dd Thu Feb 22, 2024
.Dt utf8fmt 1
.Sh NAME
.Nm utf8fmt
.Nd UTF-8 text wrapper
.Sh SYNOPSIS
.Nm utf8fmt  Oo -a Oc Oo -f Oc Oo -s Oc Oo -l Ao line-length Ac Oc Oo Ao input filename | - Ac Oo output filename Oc
.Sh DESCRIPTION
utf8fmt reflows a stream of UTF-8 input text into lines of UTF-8 output
text no longer than a specified number of UTF-8 characters + a newline.
.Pp
utf8fmt breaks the input stream into tokens of contiguous non-whitespace
characters.  utf8fmt outputs the tokens in input order adding whitespace as
follows.
.Pp
utf8fmt adds one space character (U+20) after tokens in output lines unless
the tokens occur at the end of output lines.
.Pp
utf8fmt terminates output lines with a newline character (U+0A).
.Pp
utf8fmt converts input lines without tokens into empty output lines.
.Sh OPTIONS
.Bl -tag -width '-x'
.It -f
prevents utf8fmt from terminating lines with newlines unless those lines
are empty or they precede an empty line.  In other words, utf8fmt reflows
paragraphs into single newline-terminated lines.
.It -s
causes utf8fmt to output two space characters after sentence-ending
punctuation marks [.?!] when they occur at the end of tokens that do not
occur at the end of output lines.  utf8fmt outputs two spaces when the
punctuation marks occur before quote marks ["' U+2019 U+201D U+00BB ] that
occur at the end of tokens that do not occur at the end of lines.  In this
case the two spaces are output after the quote marks.
.It -a
is only effective if the -s option is also supplied on the command line.
The -a option causes utf8fmt to NOT output two spaces after
Mr. Mrs. Ms. M. MM. Mme. Mmes. Mlle. or Mlles.  If these abbreviations are
followed by quote marks, the abbreviations are not recognized.  Two spaces
are added after the quote marks if they occur at the end of tokens that do
not occur at the end of output lines.
.It -l
specifies the maximum length of output lines in UTF-8 characters.  The
maximum length defaults to 79.  The maximum length is the maximum length of
output lines before utf8fmt appends newlines to the lines.
.El
.Sh AUTHORS
.An James Bailie Aq bailie9@icloud.com
.br
http://mammothcheese.ca
