.Dd Wed Nov 22, 2017
.Dt tsml2sqlite 1
.Sh NAME
.Nm TMSL to SQLite
.Nd converts TSML documents to Sqlite Databases.
.Sh SYNOPSIS
.Nm tsml2sqlite Oo -f Ao filename Ac
.Sh DESCRIPTION
The tsml2sqlite utility converts a TSML document into a SQLite database.
The tsmlquery(1) munger module provides functions to query databases.  TSML
is defined in tsml(5).
.Pp
By default, the database is created in the current working directory and
is named tsml.db.  A different path and filename can be specified with the
-f command line option.
.Ss DATABASE SCHEMA
The TSML table contains records representing the TSML document.  Records in
the TSML table have four columns:
.Bl -tag -width parent
.It index
contains a unique natural number identifier for each
record.
.It path 
describes the record's hierarchical relationship to the rest of the
document.  The path field resembles a filesystem path.  The paths in a
TSML document are not unique.
.It data
contains document text if the record describes a segment of document data
or the empty string otherwise.
.It parent
contains the index field of the record's parent element or 0 if the record
represents the toplevel element.
.El
.Pp
Consider the following simple TSML document:
.Bd -literal -offset left
[TSML[blather[inner[booger]]blather]TSML]
.Ed
.Pp
After parsing by tsml2sqlite, the following TSML table will have been
created:  
.Bd -literal -offset left
index           path            data        parent
-----           ----            ----        ------
1               \\TSML           ''          0
2               \\TSML\\          blather     1
3               \\TSML\\inner     ''          1
4               \\TSML\\inner\\    booger      3
5               \\TSML\\          blather     1
.Ed
.Pp
Records that represent elements have path fields that do not end with a
backslash and have empty data fields.  Records that represent document data
have path fields that end with a backslash and have non-empty data fields.
.Pp
Record 1 represents the TSML element.  The data column for this
element is the empty string because it represents the element itself and
not its content.  Record 1's parent element is set to 0 to indicate that
record 1 is a toplevel element.
.Pp
Record 2's path field is identical to record 1's except for the addition
of a trailing backslash.  Record 2 represents the first segment of
document data in the TSML element.  The data field contains the text
blather.
.Pp
Record 3 represents the inner element.  Record 4 represents the
document data of the inner element.  Record 5 represents the second
segment of document data in the TSML element.
.Sh AUTHORS
.An James Bailie Aq jimmy@mammothcheese.ca
.br
http://www.mammothcheese.ca
