/*
 * Nellie Copyright (c) 2017-2021, James Bailie.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *     * The name of James Bailie may not be used to endorse or promote
 * products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <math.h>
#include <errno.h>
#include <time.h>

#include "zlib.h"
#include "stringstack.h"

enum lexemes { ROOT, EMPTY, OPEN, CLOSE, DATA };
enum paras   { ACT, SCENE, SHOT, ACTION, CUE, LCUE, RCUE, PAREN, DIALOG, IDIALOG, LYRIC, TRANS, END };

#define CUE_LEN    33
#define PAREN_LEN  20
#define DIALOG_LEN 34

#define _WIDTH    612
#define _LENGTH   792

#define _A4_WIDTH  595
#define _A4_LENGTH 842

#define _PAGENO    756.0
#define _A4_PAGENO 806.0

#define _FULL_LEN    60
#define _A4_FULL_LEN 58

#define NUMBER_OFF 8
#define FULL_OFF   15

#define DIALOG_OFF 25
#define PAREN_OFF  29
#define CUE_OFF    35

#define LDIALOG_OFF 15
#define LPAREN_OFF  19
#define LCUE_OFF    25

#define _RDIALOG_OFF 41
#define _RPAREN_OFF  45
#define _RCUE_OFF    51

#define _A4_RDIALOG_OFF 38
#define _A4_RPAREN_OFF 42
#define _A4_RCUE_OFF 48

#define _SCENE_ORPH    48
#define _A4_SCENE_ORPH 52
#define _CUE_ORPH      49
#define _A4_CUE_ORPH   53

#define _LINES    52
#define _A4_LINES 56
#define _CHARS    85
#define _A4_CHARS 83

#define LEADING 12.5
#define INDENT 4

#define RIGHTCHARS 10
#define LEFTCHARS  15

#define _QUARTER    594
#define _A4_QUARTER 604
#define _HALF       396
#define _A4_HALF    421

#define BOTTOM  72
#define _TOP    712
#define _A4_TOP 762
#define LEFT    108

#define TREE           40
#define INTERMEDIARIES 20

#define WATERMARK_SCALE 5
#define WATERMARK_SIZE "60"
#define WATERMARK_TRANS "0.90"

struct tsml
{
   enum lexemes type;
   char *data;
   struct tsml *children, *next;
};

struct meta
{
   int obj, words;
   char *title, *author, *revision, *contact, *watermark, *copyright, *language;
};

struct para
{
   enum paras type;
   int scene;
   char shot;
   struct stack *lines;
   struct para *next;
};

struct page
{
   int total, parent;
   struct stack *lines;
};

void free_tsml_tree( struct tsml * );
struct tsml *make_tsml_tree( FILE * );

void free_meta( struct meta * );
struct meta *make_meta();

void free_para_list( struct para * );
struct para *make_para_list( struct tsml *, struct meta *, char *, int );

void free_page_stack( struct stack * );
struct stack *make_page_stack( struct para *, int, int, int, int );

void free_pdf( struct stack * );
struct stack *make_pdf( struct stack *, struct meta *, int );

struct stack *split_and_normalize( char * );
void free_items( struct stack * );

char *make_date();
char *make_words( int, char * );

int extract_metadata( struct tsml *, struct meta * );

int same_cue( char *, char * );

struct stack *make_scene_number_list( char * );
int add_scene_numbers( int, struct stack *, int, char *, int );

struct string *scalar_to_utf8( int );
int process_accent( unsigned char *, struct string * );

