.Dd Sat Sep 16, 2022
.Dt libmultifile 3
.Sh NAME
.Nm libmultifile
.Nd Client Library for multifile(1)
.Sh SYNOPSIS
.Nm #include <multifile.h>
.Nm -I/usr/local/include -L/usr/local/lib -lmultifile -lcrypto -lssl
.Sh DESCRIPTION
libmultifile provides reentrant, blocking-IO code to communicate with
multifile servers.
.Pp
.Ss USAGE
The library provides 6 functions.
.Bd -literal -offset left
char fc_error[ 256 ];

SSL_CTX *ctx;

struct fc_ssl {
   SSL *ssl;
   int fd;
};

int fc_init( int );
void fc_deinit();

struct fc_ssl *fc_connect_to_server( char *, char *, int, int );
void fc_close_connection( struct fc_ssl * );

int fc_read_frame( struct fc_ssl *, unsigned char * );
int fc_send_frame( struct fc_ssl *, unsigned char *, unsigned int );
.Ed
.Pp
Do not define any other global symbol beginning with the 3 characters
\'fc_' because the library reserves that namespace.
.Ss FC_INIT()
Use fc_init() to initialize OpenSSL before using any of the other
functions.  Note that this function sets SIGPIPE to be ignored.
.Bd -literal -offset left
int fc_init();
.Ed
.Pp
On success, the function returns 0.
.Pp
On error, the function returns -1 and writes an error message into fc_error.
.Ss FC_DEINIT()
Use fc_deinit() to free the OpenSSL context when you are finished using
the library.
.Bd -literal -offset left
void fc_deinit();
.Ed
.Ss FC_CONNECT_TO_SERVER()
Use fc_connect_to_server() to establish a connection to a multifile server.
.Bd -literal -offset left
struct cm_ssl *fc_connect_to_server( char *hostname, char *port, int ignore );
.Ed
.Pp
The hostname argument is a string representing the hostname or IP address
of the host on which the server is running.
.Pp
The port argument is a string representing the port on which the server is
listening.
.Pp
The ignore argument indicates whether or not to ignore a mismatch between
the hostname and the hostname on the server's certificate.  This is useful
for debugging over the loopback interface.
.Pp
On success, the function returns a pointer to a struct fc_ssl.
.Pp
On failure, the function returns NULL and writes an error message into
fc_error.
.Ss FC_CLOSE_CONNECTION()
Use fc_close_connection() to close a connection.
.Bd -literal -offset left
void fc_close_connection( struct fc_ssl * );
.Ed
.Pp
The function shuts down the TLS connection, closes the underlying
descriptor, and frees the struct fc_ssl pointed to by the argument.
.Ss FC_READ_FRAME()
Use fc_read_frame() to read a frame from a server.  If you want to
timeout the read, use setsockopt() to place a timeout on the underlying
socket (the fd member of the struct ssl).
.Bd -literal -offset left
int fc_read_frame( struct fc_ssl *conn, unsigned char *buffer );
.Ed
.Pp
The conn argument is the pointer returned by fc_connect_to_server().
.Pp
The buffer argument is a character array of 1056 elements.
.Pp
On success, the function reads an incoming frame's payload into buffer and
returns the number of characters read.
.Pp
On EOF, the function returns 0.
.Pp
On error, the function returns -1 and writes an error message into
fc_error.
.Ss FC_SEND_FRAME()
Use fc_end_frame() to send a frame to a server.
.Bd -literal -offset left
int fc_send_frame( struct fc_ssl *conn, unsigned char *buffer, unsigned int len );
.Ed
.Pp
The conn argument is the pointer returned by fc_connect_to_server();
.Pp
The buffer argument is a character array containing frame payload data.
.Pp
The len argument is the length of the data in buffer.  The length
must be between 1 and 1056 bytes in length.
.Pp
On success, the function sends the frame to the server and returns 0.
.Pp
If the peer has closed the connection, the function returns -2.
.Pp
On error, the function returns -1 and writes an error message into
fc_error.
.Sh AUTHORS
.An James Bailie Aq bailie9@icloud.com
.br
mammothcheese.ca
