; Copyright (c) 2026, James Bailie <jimmy@mammothcheese.ca>.
; All rights reserved.
;
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following conditions are met:
;
;     * Redistributions of source code must retain the above copyright
; notice, this list of conditions and the following disclaimer.
;     * Redistributions in binary form must reproduce the above copyright
; notice, this list of conditions and the following disclaimer in the
; documentation and/or other materials provided with the distribution.
;     * The name of James Bailie may not be used to endorse or promote
; products derived from this software without specific prior written permission.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND CONTRIBUTORS "AS IS"
; AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
; ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
; LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
; CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
; SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
; INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
; CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
; ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
; POSSIBILITY OF SUCH DAMAGE.

#include "stacks.mm"
#include "tsmlquery.mm"

(declare result 0)

(when (stringp (bind result (sqlite_open "tsml.db")))
   (die result))

(declare queue (stack))

(declare query_print
   (lambda ()
      (let ((result (get_data 1 queue)))
         (if (not (stackp result))
            (eval 0)
            (apply_stack (lambda (x) (println x)) result)
            (eval 1)))))

(push queue "News Feed")
(push queue 1)
(push queue "Source")
(push queue 1)
(push queue "Title")
(push queue 1)
(query_print)

(store queue 4 "Link")
(query_print)

(store queue 4 "Description")
(query_print)

(store queue 2 "Item")

(declare query_print_items
   (lambda (k n)
      (store queue 3 n)
      (store queue 4 "Title")
      (unless (query_print)
         (k 0))

      (store queue 4 "Link")
      (query_print)

      (store queue 4 "Description")
      (query_print)

      (query_print_items k (+ n 1))))

(call_cc (lambda (k) (query_print_items k 1)))
(sqlite_close)
