; Copyright (c) 2004, James Bailie <jimmy@mammothcheese.ca>.
; All rights reserved.
;
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following conditions are met:
;
;     * Redistributions of source code must retain the above copyright
; notice, this list of conditions and the following disclaimer.
;     * Redistributions in binary form must reproduce the above copyright
; notice, this list of conditions and the following disclaimer in the
; documentation and/or other materials provided with the distribution.
;     * The name of James Bailie may not be used to endorse or promote
; products derived from this software without specific prior written permission.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND CONTRIBUTORS "AS IS"
; AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
; ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
; LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
; CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
; SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
; INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
; CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
; ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
; POSSIBILITY OF SUCH DAMAGE.

; Helper function. Not for use by calling code.

(declare _apply_stack_helper
   (lambda (f s e a)
      (when (< s e)
         (f (index a s))
         (_apply_stack_helper f (+ s 1) e a))))

; Apply a closure to the elements of a stack. Discard the results.

(declare apply_stack
   (lambda (f a)
      (_apply_stack_helper f 0 (used a) a)))

; Helper function. Not for use by calling code.

(declare _map_stack_helper
   (lambda (f s e a r)
      (if (>= s e)
         r
         (push r (f (index a s)))
         (_map_stack_helper f (+ s 1) e a r))))

; Apply a closure to the elements of a stack. Collect the results in another
; stack. Return the new stack.

(declare map_stack
   (lambda (f a)
      (_map_stack_helper f 0 (used a) a (stack))))
