(declare result 0)

(when (stringp (bind result (sqlite_open "/usr/local/share/minimunger/test.sqlite")))
   (die result))

(when (stringp (bind result (sqlite_prepare "SELECT Title, Body FROM Articles")))
   (die result))

(declare iterate
   (lambda (sql)

      (letn ((step (sqlite_step sql))
             (row  (and (not (stringp step)) step (sqlite_row sql))))

         (unless (stackp row)
            (when (stringp step)
               (die step))
            (when (stringp row)
               (die row)))

         (when step
            (letn ((newline (char 10))
                   (total (used row))
                   (pairs (and (/ total 2) (not (% total 2)))))

               (when pairs
                  (println newline "TITLE:" newline (index row 0) newline)
                  (println "BODY: " newline (index row 1))))

            (iterate sql)))))

(iterate result)

(when (stringp (bind result (sqlite_finalize result)))
   (die result))

(sqlite_close)
