; Copyright (c) 2005, James Bailie <jimmy@mammothcheese.ca>.
; All rights reserved.
; 
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following conditions are met:
; 
;     * Redistributions of source code must retain the above copyright
; notice, this list of conditions and the following disclaimer.
;     * Redistributions in binary form must reproduce the above copyright
; notice, this list of conditions and the following disclaimer in the
; documentation and/or other materials provided with the distribution.
;     * The name of James Bailie may not be used to endorse or promote 
; products derived from this software without specific prior written permission.
; 
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND CONTRIBUTORS "AS IS"
; AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
; ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
; LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
; CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
; SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
; INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
; CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
; ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
; POSSIBILITY OF SUCH DAMAGE.

; Usage grep [ -n ] pattern [file1 ...]

#include "options.mm"

(getopt (push (stack) "n"))
(declare enum (lookup options "n"))

(unless (next)
   (die "pattern missing"))

(when (stringp (declare rx (regcomp (current))))
   (die rx))
   
(declare count 0)
(declare curfile "")

(declare grep
   (lambda (line)
      (when line
         (bind count (+ count 1))

         (when (match rx line)
            (when curfile
               (print curfile ": "))
            (when enum
               (print count ": "))
            (print line))

         (grep (getline)))))

(declare foreach_source
   (lambda (file)
      (when file
         (bind curfile (basename file))

         (with_input_file file
            (grep (getline)))
         
         (bind count 0)
         (foreach_source (next)))))
   
(if (next)
   (foreach_source (current))
   (grep (getline)))
