.Dd Mon, May 26, 2025
.Dt dkns 1
.Sh NAME
.Nm dkns
.Nd Text editor
.Sh SYNOPSIS
.Nm dkns Oo Ao line-number Ac Oc Ao filename Ac
.Sh DESCRIPTION
Dickens is an old-school, black-and-white, one-buffer-in-one-window console
text editor for 8-bit text.  Dickens does not understand UTF-8.  Dickens is
written in a custom dialect of lisp called Munger, so the editor is
programmable, but Dickens is not Emacs.
.Ss Keys and Chords
In the command summaries which follow, lone letters preceded by C- indicate
a key chord in which the specified key is to be pressed at the same time as
the control key.  Lone letters preceded by M- indicate a key chord in which
the specified key is to be pressed at the same time as the alt/meta key, or
you can precede the specified key by a separate press of the ESC key.
.Pp
Chords made with the control key always consist of a lower case character
and the control key, but chords made with the meta key consist of either
the upper or lower case version of a character and the meta key.  For
example, M-c and M-C are two distinct commands.
.Pp
Keys or key chords preceded by C-x indicate this chord is to be pressed
first separately, followed by the succeeding keys or key chords.  Such
commands are called extended commands.  While waiting for the second part
of an extended command, the editor displays "C-x ?" in the status line.  To
cancel a pending extended command, press C-u.
.Pp
In the command summaries that follow, a paragraph forward is those lines of
text from the line the cursor is on to the line to which the cursor moves
when M-} is invoked.  A paragraph backward is those lines of text from the
line the cursor is on to the line to which the cursor moves when C-{ is
invoked.
.Ss Exiting
.Bl -tag -width "C-x C-c"
.It C-x C-c
exits the editor.
.It C-x 9
Will write unsaved changes to disk and exit the editor.
.El
.Ss Command-Line Arguments
Command line arguments specify files to load on startup.  If the first
character of the first argument is a plus sign (+), then the remaining
characters of that argument are considered to specify a line number to move
the cursor to after loading the file specified by the second argument.  If
the remainder of the first argument is not a positive integer, it is
ignored, but the file specified by the second argument is still loaded.  If
the first argument does not begin with a plus sign, then it is assumed to
be a filename to load into the buffer on startup.  To load a file whose
name begins with a plus sign, pass a do-nothing line number argument, or
qualify the filename:  
.Bd -literal -offset left
% dkns +1 +funnyfile
.Ed
.Bd -literal -offset left
% dkns ./+funnyfile
.Ed
.Pp
Other command-line arguments are assumed to be filenames, and are pushed
onto the file stack.  See the section titled "Working With Files" for more
information on using the file stack.
.Ss Configuration Options
The editor has five configuration settings.
.Bl -tag -width "line_length"
.It line_length
This option is a positive integer specifying the desired maximum length of
lines.  This value is used by the auto-wrapper and by the paragraph
formatter.
.It tab_stop
This option is a positive integer specifying the frequency of tabstops.
Tabstops are considered to occur every tab_stop characters ad infinitum in
the line.
.It auto_indent
This option is a boolean which specifies whether or not leading whitespace
from the preceding line should be propagated to a new line when the user
terminates a line.
.It auto_wrap
This option is a boolean which specifies whether or not lines should be
automatically wrapped when manual input causes a line to exceed the value
of line_length.
.It show_match
This option is a boolean which specifies whether or not the location of
opening delimiters are indicated visually when a closing delimiter is
input (")", "}", or "]").  If the opening delimiter cannot be found, the
terminal bell is sounded.  In no case will the editor search farther back
than the line which the cursor would be moved to if an C-x [ command were
invoked from the original cursor position.
.El
.Pp
The user's startup configuration file, if it exists, must be named .dkns and
be located in the user's home directory.  The following example shows code
to modify the configuration settings.
.Bd -literal -offset left
; These values must be set via a function call.

(set_line_length 75)
(set_tab_stop 3)

; The boolean flags may be set directly.

(setq auto_indent 1)
(setq auto_wrap 1)
(setq show_match 1)
.Ed
.Pp
The following commands are used to inspect or change the configuration
settings from within the editor.
.Bl -tag -width "C-x B"
.It C-x @
displays the values of the user settings.
.It C-x N
sets a new value for the line_length variable.
.It C-x B
sets a new value for the tab_stop variable.
.It C-x I
toggles the value of the auto_indent variable.
.It C-x U
toggles the value of the auto_wrap variable.
.It C-x M
toggles the value of the show_match variable.
.El
.Ss Command Prompts
Some commands require textual or numerical input from the user.  The editor
prompts for this input on the status line.  At any command prompt, three
editing commands are available.  Interactive completion and a
browsable history may also be available for the prompt.  To input a tab use
C-a.  To input any other character bound to editing commands, type C-v
followed by the desired character.
.Bl -tag -width "C-p"
.It C-h
backspaces over the last character of input.
.It C-w
backspaces over the last complete word on the command line.
.It C-u
backspaces over the entire command line.
.It C-p
causes the text input so far to be replaced with the most recent item in the
command's saved history.  Successive invocations of this command continue
to advance backward through the command history.
.It C-n
If the C-p command has been invoked, this command causes the current text
on the command line to be replaced with the next item in the command
history.  Successive invocations of this command continue to advance
forward through the command history until the original input text is
reached.
.It C-a
inserts a tab character into the input text.
.It [tab]
invokes interactive filename completion.
.It C-c
cancels the input operation.
.El
.Ss Repeating Commands
.Bl -tag -width "C-x c"
.It M-o
causes the user to be prompted for a repeat count.  The next command
invoked is repeated the specified number of times.  Those commands for
which a repeat count does not make sense ignore the repeat count.
.It C-x g
repeats the most recently invoked command.  This command respects the
repeat count given to the original command.
.It C-x [space]
starts or stops recording keystrokes for subsequent playback.
.It M-[space]
plays the recorded keystrokes.  If this command is given a repeat count, it
is respected.  If C-g is invoked after invoking this command, the last
command in the set of recorded keystrokes is invoked and not the playback
operation.
.El
.Ss The Region
An abitrary region of text may be delineated for certain operations.  The
region consists of the text lying between the cursor and the mark.  The
cursor and the mark are both considered to be between the character they
are over and the previous character in the buffer.  At the endpoint
that occurs earlier in the buffer, the character under the endpoint is
included in the region.  At the endpoint occurring later in the buffer, the
character under the endpoint is outside the region.
.Bl -tag -width "C-[space]"
.It C-[space]
sets the mark before the character the cursor is over.
.It C-x C-e
exchanges the cursor position and the mark.
.El
.Ss Working With Files
.Bl -tag -width "C-x C-s"
Filename completion is triggered by entering a tab at the filename prompt.
Tab characters themselves can be entered at the prompt by invoking C-a.  To
input any character bound to a line-editing command, type C-v followed by
the desired character.  If the last line of a file is not terminated with a
newline, the editor adds a newline to the end of that line.
.It C-x C-f
loads the buffer from a file.  The buffer is emptied first, and the user is
prompted for the filename.  If the specified file does not exist, the
editor assumes the user wants to edit a new file.
.It C-x 2
stores the filename currently associated with the buffer and the cursor
position, then loads the buffer from a new file.  The filename and cursor
position are stored on a stack, and may be returned to at a later time.
The specified file must exist, or an error is generated.
.It C-x 3
pops the last saved filename and cursor position off the saved file
stack.  The editors loads the file and jumps to the saved cursor position.
.It C-x 4
exchanges the current file and cursor position with those stored on top of the
file stack.  This command can be used to quickly switch between two files.
.It C-x D
pushes the current file and cursor position onto the file stack, then shifts
the filename and cursor position off the bottom of the file stack.  The
editor loads that file and jumps to that cursor position.  This command may
be used to visit each of the files on the file stack in a circular manner
ad infinitum.
.It C-x C-s
saves the buffer to a file.  If the buffer was loaded from a file, the
buffer is written back to that file.  Otherwise, the user is prompted for a
filename.  Successive invocations of this command reuse that filename.
.It C-x C-a
lists the filenames saved on the file stack.
.It C-x C-i
Inserts a file into the buffer after the line the cursor is on.  The user
is prompted for the filename.  If the cursor is on the first line in the
buffer, the user is prompted to choose between inserting the file content
before or after the first line.
.It C-x W
writes the lines of the region to a file.  The user is prompted for the
filename.
.It C-x F
prompts the user for a new filename to associate with the buffer.  Subsequent
invocations of C-x C-s use this filename.
.El
.Ss Working With External Commands
.Bl -tag -width "C-x &"
For these commands, the region is considered to include the entire lines
the region endpoints lie on, which is to say that these commands work on
whole lines.  These commands also prompt the user for a command line, which
is passed to the shell (/bin/sh) for execution.
.It C-x C-m
filters the region through an external command.  The lines in the region are
replaced by the command's output.
.It C-x &
inserts the output of a specified command into the buffer, after the current
line.
.It C-x *
writes the lines in the region to the standard input of a specified command.
.It C-x\ !
runs a command under the shell.
.It C-x $
suspends the editor and returns to the shell from which it was launched.
.El
.Ss Moving The Cursor And Scrolling The Buffer
Lines longer than the width of the terminal are truncated onscreen, but the
editor scrolls the screen horizontally if an attempt is made to move
to a destination off the edge of the screen.
.Bl -tag -width "C-x f"
.It C-f
moves the cursor a character forward in the buffer.
.It C-b
moves the cursor a character backward in the buffer.
.It M-f
moves the cursor forward a word in the buffer.
.It M-b
moves the cursor backward a word in the buffer.
.It C-a
moves the cursor to the beginning of the current line.
.It C-e
moves the cursor to the end of the current line.
.It M-a
moves the cursor to the sentence ending punctuation mark occuring before
the cursor.
.It M-e
moves the cursor to the sentence ending punctuation mark occuring after the
cursor.
.It M-}
moves the cursor forward to the next blank line or to the line line with a
full-stop in column zero.
.It M-{
moves the cursor backward to the previous blank line or to the line with a
full-stop in column zero.
.It M-\]
moves the cursor forward in the buffer to the next line having an opening
parenthesis, an opening brace, or a full-stop followed by an uppercase S in
column zero (troff section).
.It M-[
moves the cursor backward to the previous line in the buffer having an
opening parenthesis, an opening brace, or a full-stop followed by an
uppercase S in column zero.
.It M-^
moves the cursor to the first non-whitespace character in the current line,
if any.
.It M-+
moves the cursor to the first non-whitespace character in the line immediately
after the line the cursor is on.
.It M--
moves the cursor to the first non-whitespace character in the line immediately
preceding the line the cursor is on.
.It M-n
scrolls the buffer upward by one line.
.It M-p
scrolls the buffer downward by one line.
.It C-t
scrolls the buffer upward to place the line the cursor is on at the top of the
screen.
.It C-l
scrolls the buffer to place the line the cursor is on in the middle of the
screen.
.It C-c
scrolls the buffer downward to place the line the cursor is on at the bottom
of the screen.
.It C-x 0
moves the cursor to first character of the line at the top of the screen.
.It C-x 1
moves the cursor to the first character of the line at the bottom of the screen.
.It C-x l
moves the cursor to the line in the center of the screen.
.It C-v
scrolls the buffer upward by one screenful of lines.  The cursor is moved
to the bottom line on the screen.
.It M-v
scrolls the buffer downward by one screenful of lines.  The cursor is moved
to the top line on the screen.
.It M->
moves the cursor to the last character in the buffer.
.It M-<
moves the cursor to the first character in the buffer.
.It C-x #
moves the cusror to line specified by the user by line number.
.El
.Ss Marking Lines With Bookmarks
Named bookmarks can be associated with lines in the buffer.  A bookmark is
unset when the bookmarked line is deleted.
.Bl -tag -width "C-x m"
.It C-x m
associates a bookmark with the line the cursor is on.
.It C-x j
jumps to the line associated with a bookmark.
.El
.Ss Cutting And Pasting Text To And From The Clipboard
The following commands perform cut and paste operations on buffer text.
The deletion commands unset the mark.  The text on the clipboard is
overwritten with every deletion or copy except when deletion commands are
invoked with a repeat count or when C-k command is invoked multiple
times in succession.  In those situations, the successive deletions are
appended to form one item on the clipboard.  To preserve the contents of
the clipboard for later use, it can be pushed onto a stack.
.Bl -tag -width "C-x C-p"
.It C-x C
copies the region to the clipboard.
.It M-c
copies text to the clipboard from the cursor position to the end of the
line.  Suppying a repeat count to this command determines the number of
lines copied.  A repeat count of 1 is the same as supplying no repeat
count.  The terminating newline of the last line affected is not copied.
.It M-C
copies text to the clipboard from the cursor position to the end of the
current paragraph.  Supplying a repeat count to this command determines the
number a paragraphs from which text is copied.  Supplying a repeat
count of 1 is the same as supplying no repeat count.
.It C-d
deletes the character under the cursor.
.It C-h
deletes the character before the cursor.
.It M-d
deletes the word that occur after the cursor position.
.It M-h
deletes the word that is occurs before the cursor.
.It C-x C-p
deletes successive whitespace characters from the cursor location to the next
non-whitespace character in the current line.  The deleted whitespace is
not stored on the clipboard.  The user can restore accidentally-deleted
whitespace with the undo command.
.It C-k
deletes the characters in the line from the cursor position forward to the end
of the line creating a blank line.  Invoking this command on a blank line
deletes the terminating newline, causing the blank line to be removed from
the buffer.  If this command is given a repeat count, the command deletes
whole lines.  Successive invocations of this command cause each separate
deletion to be appended to form one item on the clipboard.
.It M-k
deletes the characters from the start of the line the cursor is on to the
cursor position.
.It C-x E
deletes a sentence forward.
.It C-x A
deletes a sentence backward.
.It C-x i
deletes a paragraph forward
.It C-x o
deletes a paragraph backward.
.It C-x w
deletes text forward to the text that matches a regular expression.
.It C-x q
deletes text backward to the text that matches a regular expression.
.It C-x K
deletes the text from a specified bookmark to the cursor position.  The
book mark is unset after this operation.
.It C-x =
deletes text backward in the current line until the initial whitespace in the line.
.It C-x y
deletes the text from the cursor position to the end of the buffer.  The
final newline cannot be deleted.
.It C-x u
deletes the text from the beginning of the buffer to the cursor position.
.It C-x C-d
deletes the text delineated by the region.
.It C-y
pastes the content of the clipboard into the buffer before the cursor
position.  The region is set to the inserted text, so that it may be removed
again by invoking C-x C-d, or M-y.
.It M-y
if the region is set, deletes the region.  The clipboard stack is rotated
and the contents of the next clipboard are pasted into the buffer.  The
region is set to the pasted text.  Successive invocations allow the user to
browse the contents of the clipboard stack.
.It M-t 
pushes the current clipboard onto the clipboard stack.
.It M-g
replaces the clipboard with the clipboard on top of the clipboardstack.
.It C-x M-q
Executes M-g, followed by C-y, to pop the clipboard stack and paste the
new clipboad's content into the buffer at the cursor location.
.It C-x Q
copies the contents of the clipboard on top of the clipboard stack into the
current clipboard, and then pastes the new content into the buffer at the
cursor location.  The clipboard stack is not popped.
.El
.Ss Undoing Modifications To Buffer Content
Insertions and deletions may be undone with the undo command.  If the last
buffer-modifying command invoked was the undo command, then the redo
command is available to allow the undone changes themselves to be undone.
One can think of the undo operation as moving the buffer back in time, and
the redo operation moving the buffer forward in time.
.Bl -tag -width "C-x _"
.It C-u
undoes the last modification to the buffer.  Changes to the buffer occur in
a line-oriented manner, so these changes are undone line-by-line as well.
This means that if you deleted many lines in the buffer with one invocation
of C-x k, for example, the lines would be undeleted one at a time, by
successive invocations of this command, and not all at once.  The undo
behaviour of the editor may baffle you at first, but you are merely seeing
the changes that go on "behind the scenes," and if you keep invoking C-u,
you will get back to the buffer state you desire.  This command accepts a
repeat count.
.It C-x _
undoes the last undo operation.  This command is only available if the last
modification to the buffer was performed by an undo operation.  Once fresh
changes to the buffer have been made after the undo command has been
invoked, the redo information is discarded.  This command accepts a repeat
count.
.El
.Ss Searching For Matches On Regular Expressions
All searches wraparound to search the portion of the buffer on the opposite
side of the cursor.  A search fails if there is no match in the buffer.
.Bl -tag -width "C-s"
.It C-s
searches forward in the buffer for a match of a regular expression.
.It C-r
searches backward in the buffer for a match of a regular expression.
.It M-s
repeats the last search, searching forward in the buffer.
.It M-r
repeats the last search, searching backward in the buffer.
.El
.Ss Transforming Lines With Regular-Expression-Based Substitutions
Each of the commands below performs a regular-expression-based substitution
over a range of lines in the buffer.  For each command the user is prompted
for the pattern, the replacement text, and a repeat count to use.  A repeat
count of 0 means to replace every occurrence in the affected region.  The
replacement text can refer to the first ten parenthesized subexpressions in
the pattern by using the escape sequences \\1 to \\0, with \\0 referring to
the tenth subexpression.  The text of the entire match can be accessed with
\\&.  As well, \\U turns on conversion to uppercase and affects all text
from that point forward in the affected line, including that portion of the
line outside the replacement text.  Similarly \\L turns on conversion
to lowercase.  Either can be turned off with \\e.  The two sequences \\u
and \\l convert the single character succeeding them to upper or lower
case, respectively.  These commands are front-ends to the Munger(1)
"substitute" intrinsic.  More information on performing substitutions can
be found in the Munger(1) manual page.
.Pp
Terminating newlines are removed from lines when performing substitutions so
that "$" matches the empty string before the newline, and "^$" matches
empty lines.  The terminators are replaced when the modified lines are written
back to the buffer.
.Bl -tag -width "C-x C-r"
.It C-x t
performs a substitution on the portion of the line after the cursor.
.It C-x T
performs a substitution on the portion of the line before the cursor.
.It C-x\ )
performs a substitution on the paragraph after the cursor position.
.It C-x (
Performs a substitution on the paragraph preceding cursor position.
.It C-x S
performs a substitution on the region from the cursor position to the
occurrence of the next match of a specified regular expression in the buffer.
.It C-x R
performs a substitution on the region from the match on a specified
regular expression closest to the cursor position, occurring before the cursor
position, to the cursor position.
.It C-x C-r
performs a substitution on the region.
.It C-x J
performs a substitution on the region formed between a named bookmark and the
cursor location.  The exact region affected depends upon whether the bookmark
occurs before or after the cursor.
.It C-x\ .
performs a substitution on the region from the cursor position to the end
of the buffer.
.It C-x\ ,
performs a substitution on the region from the start of the buffer to the
cursor position.
.El
.Ss Modifying The Indentation Of Lines
The following commands alter the indentation of lines in the buffer.  The
functions that decrease indentation do so by one tab character or the
equivalent number of space characters as determined by the tabstop
variable.  Indentation is assumed to be in increments of this variable, so
for example, if it were set to three, then one tab or three space
characters would be removed from the start of the affected lines.
.Bl -tag -width "C-x C-x"
.It M-z
decreases the indentation of lines from the line the cursor is on forward
in the buffer.  Supplying a repeat count to this command determines the
number of lines the command affects.  The default is to affect only the
line the cursor is on.
.It M-x
behaves similarly to the above described command but increases the
indentation.
.It C-x z
decreases the paragraph forward from the cursor position.  Supplying a
repeat count to this command causes it to affect n paragraphs.
.It C-x x
increases the indentation of the paragraph after the cursor position.
Supplying a repeat count to this command causes it to affect n
paragraphs.
.It C-x C-z
decreases the indentation of the paragraph before the cursor position.
Supplying a repeat count to this command causes it to affect n
paragraphs.
.It C-x C-x
increases the indentation of the paragraph before the cursor position.
Supplying a repeat count to this command causes it to affect n
paragraphs.
.It C-x 5
Invokes M-%, to jump to the other end of a region delimited by parentheses,
brackets, or braces, and if successful, decreases the indentation of that
range of lines.  This command ignores repeat counts.
.It C-x 6
Invokes M-%, to jump to the other end of a region delimited by parentheses,
brackets, or braces, and if successful, increases the indentation of that
range of lines, inclusive.  This command ignores repeat counts.
.It C-x 7
decreases the indentation of the lines in the region.  This command ignores
repeat counts.
.It C-x 8
increases the indentation of the lines in the region.  This command ignores
repeat counts.
.It C-x\ `
increases the indentation of the range of lines foward from the cursor
position to the line containing the next occurrence of a match of a regular
expression, Supplying a repeat count to this command causes it to
affect lines to the nth next occurence of the specified regular expression.
.It C-x \e
decreases the indentation of the range of lines forward from the cursor
position to the line containing the next occurrence of a match of a regular
expression.  Supplying a repeat count to this command causes it to
affect lines to the nth next occurence of the specified regular expression.
.It C-x |
decreases the indentation of the range of lines backward from the cursor
position to a match of a regular expression.  Supplying a repeat count to
this command causes it to affect lines to the nth previous occurence of
the regular expression.
.It C-x ~
increases the indentation of the range of lines backward from the cursor
position to a match of a regular expression.  Supplying a repeat count to
this command causes it to affect lines to the nth previous occurence
of the regular expression.
.El
.Ss Altering The Capitalization Of Words
.Bl -tag -width "M-;"
.It M-;
capitalizes the character under the cursor and converts any succeeding
non-whitespace characters to lowercase.
.It M-"
converts the contiguous non-whitespace characters from the cursor position
forward to lowercase.
.It M-:
converts the contiguous non-whitespace characters from the cursor position
forward to uppercase.
.El
.Ss Reforming Paragraphs Of Text
The following commands filter a range of buffer lines through the
fmt.munger script, which is part of the Munger(1) distribution.  Any tabs
in the formatted region are expanded, according to the value of the
tabstop variable and their position in the line.  The maximum length of
formatted lines is determined by the value of the line_length variable.
.Bl -tag -width "C-x C-q"
.It M-q
formats the paragraph forward the cursor position.  Supplying a repeat
count to this command causes it to affect n paragraphs.
.It M-w
formats the paragraph backward from the cursor position.  Supplying a
repeat count to this command causes it to affect n paragraphs.
.It C-q
formats the paragraph forward from the cursor position propagating 
non-alphabetic prefix characters, possibly delimited by whitespace on
either or both sides.  The prefix is taken from the first line to be
formatted.  This command is used to format some types of program comments
and citations in email messages.  Supplying a repeat count to this command
causes it to affect n paragraphs.
.It C-w
formats the paragraph backward from the cursor position propagating
non-alphabetic prefix characters, possibly delimited by whitespace on
either or both sides.  The prefix is taken from the first line to be
formatted.  This command is used to format some types of program comments
and citations in email messages.  Supplying a repeat count to this command
causes it to affect n paragraphs.
.El
.Ss Working With Tags
The following command can be used to find the location of a toplevel
definition in program code, using tags tables.  See ctags(1) for more
information on tags.
.Bl -tag -width "C-x C-g"
.It C-x C-g
prompts the user for a symbol name on the status line.  If the cursor
appears to be on a symbol in the buffer, that symbol appears on the
status line as a default value.  Tag completion is available at the prompt
and is triggered by pressing the tab key.  The editor looks up the symbol
the user specifies in the tags file in the current directory.  If a tag is
found, the editor loads the appropriate file and jumps to the location of
the definition for that symbol.  The current filename and cursor position
are pushed onto the file stack and can be returned to with the C-x 3
command.
.El
.Ss Evaluating Munger Code
.Bl -tag -width "C-x C-l"
.It C-x L
sends the s-expression immediately before the cursor position to another
munger process for evaluation.  The editor reads and pages the output.
The editor complains if it does not receive output immediately.  Any
subsequently arriving data is paged by invoking C-x\ ?.
.It C-x\ ?
displays any output pending.
.It C-x C-l
terminates the external munger process.
.El
.Ss Miscellaneous Commands
.Bl -tag -width "C-x g"
.It C-x s
Causes the editor to remove trailing contigous whitespace characters from
the ends of buffer lines.  Lines consisting of only whitespace become
blank lines.
.It M-%
instructs the editor to move the cursor to the location of the delimiter
which matches ("closes") the delimiter character under the cursor.  If the
cursor is not on a "(", ")", "[", "]", "{", or "}" character, an error message
is displayed in the status line.
.It C-o
inserts a blank line into the buffer before the line the cursor is on.
.It C-x g
displays the filename associated with the buffer, the cursor position, and
whether or not the buffer contains unsaved changes.
.It C-x V
displays the version of the editor and the version of Munger on which is it
running.
.It C-x C-v
displays the number of words in the buffer.
.It M-i
allows the user to insert any character its keyboard can generate except
the carriage return character (ascii 13), into the buffer.
.El
.Sh AUTHOR
.An James Bailie Aq bailie9@icloude.com
.br
http://www.mammothcheese.ca
