/*
 * LibTable Copyright (c) 2017, James Bailie.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *     * The name of James Bailie may not be used to endorse or promote
 * products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "table.h"

void deallocator( union table_key key, union table_value value )
{
   free( value.ptr );
}

void printer( struct table_element *element, void *data )
{
   printf( "%f => %s\n", element->key.idx, ( char *)element->value.ptr );
}

int main( int argc, char **argv )
{
   struct table *table;
   union table_key key;
   union table_value value;
   char buffer[ 16 ];
   int n;

   if (( table = table_make( TABLE_FLOAT, 250000 )) == NULL )
      exit( 1 );

   for( n = 0; n < 1000000; ++n )
   {
      key.idx = n;

      snprintf( buffer, sizeof( buffer ), "value %d", n );
      value.ptr = strdup( buffer );

      if ( table_insert( table, NULL, key, value ))
         break;
   }

   table_traverse( table, printer, NULL );
   putchar( '\n' );

   for( n = 0; n < 1000000; ++n )
   {
      key.idx = n;
      table_delete( table, deallocator, key );
   }

   table_destroy( table, deallocator );
   return 0;
}
