.Dd Sun, Jan 11, 2026
.Dt libtable 3
.Sh NAME
.Nm libtable
.Nd Hash tables with int or char * keys
.Sh SYNOPSIS
.Nm #include <table.h>
.Nm -I/usr/local/include -L/usr/local/lib -ltable
.Sh DESCRIPTION
LibTable provides hash tables with float or character array keys.
.Pp
All library functions are reentrant if concurrent invocations are applied
to different structures.
.Sh USAGE
The library uses structures defined in table.h:
.Bd -literal -offset left
union table_key
{
   char *str;
   float idx;
};

union table_value
{
   void *ptr;
   float num;
};

struct table_element
{
   union table_key key;
   union table_value value;
   struct table_element *next;
};

#define TABLE_STRING 0
#define TABLE_FLOAT  1

struct table
{
   int size, type;
   struct table_element **data;
};
.Ed
.Ss TABLE_MAKE()
Create a new hash table with table_make().
.Bd -literal -offset left
struct table *table_make( int type, int size );
.Ed
.Pp
table_make() returns a pointer to a new table initialized for use.  If 
memory allocation fails, table_make() returns NULL.
.Pp
The first argument is the type of the table.  The type must be either
TABLE_STRING or TABLE_FLOAT.
.Pp
The second argument is the size of the data array.
.Ss TABLE_INSERT()
Insert new keys or update values with table_insert().
.Bd -literal -offset left
int table_insert( struct table *table,
                  void ( *func )( union table_key, union table_value ),
                  union table_key key, 
                  union table_value value );
.Ed
.Pp
key and value are assigned to an internal struct table_element by structure
assigment.
.Pp
On success, table_insert() returns 0.  If memory allocation fails,
table_insert() returns 1.
.Pp
The first argument is the table.
.Pp
The second argument is a function to be applied to the element currently
associated with the key before updating the element.  This function can be
used to deallocate keys and values.  Note that both the key and the value
are overwritten when updating an existing element.  The second argument can
be NULL.
.Pp
The third argument is the key.
.Pp
The fourth argument is the new value to associate with the key.
.Ss TABLE_DELETE()
Remove keys with table_delete().
.Bd -literal -offset left
void table_delete( struct table *table,
                   void ( *func )( union table_key key, union table_value value ),
                   union table_key key );
.Ed
.Pp
The first argument is the table.
.Pp
The second argument is a function to be applied to the key and value of the
element to be deleted before it is deleted.  This function can be used to
deallocate keys and values.  The second argument can be NULL.
.Pp
The fourth argument is the key to delete.
.Ss TABLE_LOOKUP()
Retrieve an element to examine or modify with table_lookup().
.Bd -literal -offset left
struct table_element *table_lookup( struct table *table, union table_key key );
.Ed
.Pp
table_lookup() returns NULL if the key is not in the table.
.Pp
The first argument is the table.
.Pp
The second argument is the key of the desired element.
.Ss TABLE_TRAVERSE()
Use table_traverse() to apply a function to all the elements in a table.
.Bd -literal -offset left
void table_traverse( struct table *table,
                     void ( *func )( struct table_element *element, void *data ),
                     void *data );
.Ed
.Pp
The first argument is the table.
.Pp
The second argument is a function to apply to elements.  The function is
called with an element pointer and a caller specified opaque data pointer.
.Pp
The third argument is the opaque data pointer to be passed to the second
argument.
.Ss TABLE_DESTROY()
Use table_destroy() to deallocate a table.
.Bd -literal -offset left
void table_destroy( struct table *table,
                    void ( *func )( union table_key key, union table_value ));
.Ed
.Pp
The first argument is the table.
.Pp
The second argument is a caller-supplied function to be applied to the keys
and values of each element before it is deallocated.  This function can be
used to deallocate keys and values.  The second argument can be NULL.
.Ed
.Ss TABLE_RESIZE()
Use table_resize() to create a new table initialized with the key/value
mappings of another table.
.Bd -literal -offset left
struct table *table_resize( struct table *table, int size );
.Ed
.Pp
table_resize() returns the new table or NULL if memory allocation fails.
When successful, table_resize() deallocates the old table with
table_destroy().
.Pp
The first argument is the old table.
.Pp
The second argument is the size of the new table's data array.
.Sh AUTHORS
.An James Bailie Aq bailie9@icloud.com
.br
mammothcheese.ca
