/*
 * LibTable Copyright (c) 2017, James Bailie.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *     * The name of James Bailie may not be used to endorse or promote
 * products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

union table_key
{
   char *str;
   float idx;
};

union table_value
{
   void *ptr;
   float num;
};

struct table_element
{
   union table_key key;
   union table_value value;
   struct table_element *next;
};

#define TABLE_STRING 0
#define TABLE_FLOAT 1

struct table
{
   int size, type;
   struct table_element **data;
};

struct table *table_make( int, int );
void table_destroy( struct table *, void ( * )( union table_key, union table_value ));
struct table *table_resize( struct table *, int );

void table_traverse( struct table *table,
                     void ( *func )( struct table_element *, void * ),
                     void *data );

int table_insert( struct table *, void ( * )( union table_key, union table_value ), union table_key, union table_value );
void table_delete( struct table *, void ( * )( union table_key, union table_value ), union table_key );

struct table_element *table_lookup( struct table *, union table_key );
