/*
 * StringStack Copyright (c) 2017, James Bailie.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *     * The name of James Bailie may not be used to endorse or promote 
 * products derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

union stack_val
{
   float num;
   void *ptr;
};

struct stack
{
   int free, used;
   union stack_val *top, *values;
};

struct string
{
   int free, used;
   char *top, *str;
};

struct stack *stack_make();
void stack_free( struct stack * );
void stack_clear( struct stack * );

int stack_push( struct stack *, union stack_val );
union stack_val *stack_pop( struct stack * );

int stack_unshift( struct stack *, union stack_val );
int stack_shift( struct stack *, union stack_val * );

struct string *string_make( char * );
void string_free( struct string * );

int string_append( struct string *, char );
int string_prepend( struct string *, char );

int string_concat( struct string *, char * );
int string_precat( struct string *, char * );
int string_assign( struct string *, char * );

int string_merge( struct string *, struct string * );
void string_clear( struct string * );

unsigned int string_UTF8_to_value( unsigned char * );
struct string *string_UTF8_to_UTF16BE( struct string * );
struct string *string_UTF8_to_UTF32BE( struct string * );

struct string *string_UTF32BE_to_UTF8( struct string * );
struct string *string_UTF16_to_UTF8( struct string * );

int string_UTF8_len( char * );
int string_UTF16BE_len( char * );

