/*
 * LibIndex Copyright (c) 2017, James Bailie.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *     * The name of James Bailie may not be used to endorse or promote
 * products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <syslog.h>
#include <stdarg.h>

union index_keyval
{
   void *ptr;
   float num;
};

struct index
{
   union index_keyval key, value;
   struct index *left, *right, *parent;
};

struct index_list
{
   union index_keyval key, value;
};

struct index_stack
{
   int free, used;
   struct index **top, **values;
};

struct index_stack *index_make_stack();
struct index *index_stack_push( struct index_stack *, struct index * );

struct index *index_init( int, struct index_list *,
                          int ( * )( const union index_keyval *,  const union index_keyval * ));

struct index *index_lookup( const struct index *, int ( * )( const union index_keyval, const union index_keyval ),
                            const union index_keyval );

struct index *index_insert( struct index *, int ( * )( const union index_keyval, const union index_keyval ),
                            const union index_keyval, const union index_keyval );

struct index *index_first( const struct index * );
struct index *index_last( const struct index * );

struct index *index_next( const struct index * );
struct index *index_previous( const struct index * );

struct index *index_traverse( const struct index *, void ( * )( struct index *, void * ), void *, int );
int index_destroy( struct index *, void ( * )( union index_keyval, union index_keyval ));

#define INDEX_STACK_PUSH( _s_, _o_ ) ( ! ( _s_ )->free ? index_stack_push( _s_, _o_ ) : \
   ( ! ( _s_ )->used ? ( --( _s_ )->free, ++( _s_ )->used, *( _s_ )->top = _o_ ) : \
     ( ++( _s_ )->top, --( _s_ )->free, ++( _s_ )->used, *( _s_ )->top = _o_ )))

#define INDEX_STACK_POP( _s_ ) ( !( _s_ )->used ? NULL : ( ++( _s_ )->free, --( _s_ )->used, \
   ((( _s_ )->top == ( _s_ )->values ) ? *( _s_ )->top : ( --( _s_ )->top, *(( _s_ )->top + 1 )))))

#define INDEX_STACK_CLEAR( _s_ ) ( _s_ )->free += ( _s_ )->used; ( _s_)->used = 0; ( _s_ )->top = ( _s_ )->values
#define INDEX_STACK_FREE( _s_ ) free(( _s_ )->values ); free(( _s_ ))
