/*
 * LibDorrit Echo Server Copyright (c) 2015-2018, James Bailie.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *     * The name of James Bailie may not be used to endorse or promote
 * products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * 1. "make echo" to build.

 * 2. run ./echo with the appropriate -l and -u options for your setup.

 * 3. Copy echo.html somewhere prospero can see it. Edit the 
 *    wss URL appropriately for your system.
 
 * 4. Configure prospero to forward requests for the wss URL to the
 *    socket that you specified with -l.  Start prospero.

 * 5. Access echo.html from your browser via prospero.
 *    DO NOT access echo.html from the browser's "open file" menu item, or
 *    the origin request header will be incorrect.

 * 6. Type into the text entry at the bottom of the screen. Your text is echoed
 *    in the transcript.

 * 7. Stop ./echo with kill `cat /var/run/echo.pid`
 */

#include <syslog.h>
#include <stdarg.h>

#include "dorrit.h"

void ws_init_func()
{
   syslog( LOG_ERR, "ws_init_func() invoked" );
   ws_set_name( "echo" );
}

void ws_exit_func()
{
   syslog( LOG_ERR, "ws_exit_func() invoked" );
}

int ws_open_callback( void *conn, char *cookie )
{
   syslog( LOG_ERR, "ws_open_callback() invoked" );
   ws_write_conn( &conn, 1, 0, 29, ( unsigned char *)"DORRIT ECHO SERVER LISTENING\n" );
   return 0;
}

void ws_close_callback( void *conn )
{
   syslog( LOG_ERR, "ws_close_callback() invoked" );
}

void ws_read_callback( void *conn, int binary, int len, unsigned char *buffer )
{
   syslog( LOG_ERR, "ws_read_callback() invoked" );
   ws_write_conn( &conn, 1, binary, len, buffer );
}
