
/*
 * Charles Copyright (c) 2018-2021, James Bailie.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *     * The name of James Bailie may not be used to endorse or promote 
 * products derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <math.h>
#include <errno.h>
#include <time.h>

#include "zlib.h"
#include "stringstack.h"

enum lexemes { ROOT, EMPTY, OPEN, CLOSE, DATA };
enum paras   { PART, SECTION, CHAPTER, BODY, EMPHASIZED, INTERRUPT };

#define OFFSET   10
#define INDENT   5
#define LEADING  12.5

#define _LEN      65
#define _A4_LEN   62

#define _WIDTH    612
#define _LENGTH   792

#define _A4_WIDTH  595
#define _A4_LENGTH 842

#define _HEAD     756
#define _LINES    52
#define _CHARS    85

#define _A4_HEAD   804
#define _A4_LINES  56
#define _A4_CHARS  82

#define _HALF     396
#define _RTF_HALF 396

#define _A4_HALF     421
#define _A4_RTF_HALF 421

#define _TOP       712
#define _A4_TOP    762

#define _RTF_TOP    72
#define _A4_RTF_TOP 72

#define _LEFT       72
#define _A4_LEFT    72

#define _RTF_LEFT    72
#define _A4_RTF_LEFT 72

#define _ORPHAN_CHAPTER    44
#define _A4_ORPHAN_CHAPTER 48

#define _ORPHAN_BODY    49
#define _A4_ORPHAN_BODY 53

#define TREE           40
#define INTERMEDIARIES 20

#define WATERMARK_SCALE 5
#define WATERMARK_SIZE "60"
#define WATERMARK_TRANS "0.90"

struct tsml
{
   enum lexemes type;
   char *data;
   struct tsml *children, *next;
};

struct meta
{
   int obj, words, part, section, chapter;
   char *title, *author, *revision, *contact, *header, *language, *copyright, *watermark;
};

struct para
{
   enum paras type;
   struct stack *lines;
   struct para *next;
};

struct page
{
   int total;
   struct stack *lines;
};

char *str_dup( char *, int );
unsigned int utf8_to_scalar( unsigned char * );

void free_tsml_tree( struct tsml * );
struct tsml *make_tsml_tree( FILE * );

void free_meta( struct meta * );
struct meta *make_meta();

void free_para_list( struct para * );
struct para *make_para_list( struct tsml *, struct meta *, int );

void free_page_stack( struct stack * );
struct stack *make_page_stack( struct para *, int );

void free_pdf( struct stack * );
struct stack *make_pdf( struct stack *, struct meta * );

struct stack *split_and_normalize( char * );

char *make_date();
char *make_words( int, char * );

void free_items( struct stack * );

int right_justify( char * );
float center_line( char *, int );

char *substitute_no( char *, int, int, int );
int extract_metadata( struct tsml *, struct meta * );

struct string *scalar_to_utf8( int );
int process_accent( unsigned char *, struct string * );
